function filePath = listBox(folder)
% get file path from list prompt 
% filePath = listBox() is the full file
% path of a file selected by the user from the folder
% 'HEVbox_Output/1SimData/' via a listBox prompt

queryFolder = dir(fullfile("results", folder, "/*.mat"));
% if isempty(queryFolder)
%     error("The current folder must be the main folder")
% end

contents = {queryFolder.name};
if isempty(contents)
    error("The folder does not contain any simulation.")
end
[s] = listdlg('PromptString','Select File:','ListSize',[400 200],...
    'SelectionMode','single','ListString',contents);
fileName = contents{s};

filePath = fullfile("results", folder, fileName);

end